#define F_CPU 16000000
//#define BAUDRATE 38400
#define BAUDRATE 19200
#define UART_CALC_BAUDRATE(baudRate) ((uint32_t)((F_CPU) + ((uint32_t)baudRate * 8UL)) / ((uint32_t)(baudRate) * 16UL) - 1)
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>

#define RED 0
#define GREEN 1
#define BLUE 2
#define YELLOW 3
#define PURPLE 4
#define CYAN 5
#define WHITE 6

#define ILLUM 3
unsigned char effect = 1;
unsigned char effect_pause[25] = {10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10};
char led[37][4];

unsigned int speed_sensor_tmp = 0;
unsigned char speed_sensor = 0;


unsigned char txt1[15] = "    TEES";
unsigned char txt2[15] = "tees.mk.ua";
unsigned char txt_color1 = RED;
unsigned char txt_color2 = RED;
unsigned char txt_counter = 12;



unsigned char ms = 5;
unsigned char start_effect = 1;
unsigned char ed =0;



void my_delay(unsigned char c)
{
while(c)
{
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
asm("nop");
//Nop();
c--;
}
}
void change_led(unsigned char led_num, unsigned char color, unsigned char stat )
{
if(color < 3)led[led_num][color] = stat;
else if(color == YELLOW){led[led_num][RED] = stat;led[led_num][GREEN] =stat;}
else if(color == PURPLE){led[led_num][RED] = stat;led[led_num][BLUE] =stat;}
else if(color == CYAN){led[led_num][GREEN]=stat;led[led_num][BLUE]=stat;}
else if(color == WHITE){led[led_num][GREEN]=stat;led[led_num][BLUE]=stat;led[led_num][RED]=stat;}
}




#include "adc.c"
#include "fonts.c"
#include "ir.c"
#include "uart.c"






void init_hall()
	{
	 DDRD &= ~(1<<PD2);
	 PORTD |= (1<<PD2);
	}
void init_int0()
	{
	MCUCR |=(1<<ISC01)|(1<<ISC00);
	GICR |=(1<<INT0);
	}
	void disable_int0()
	{
	MCUCR &= ~(1<<ISC01);
	MCUCR &= ~(1<<ISC00);
	GICR  &= ~(1<<INT0);



	}






#include "logic.c"

#include "txt.c"

#include "map.c"




char m_stat = 1;

char txt[20]; 
char caunter = 0;
ISR(INT0_vect)
{
disable_int0();
speed_sensor_tmp ++;
if(m_stat == 1)
{	m_stat = 0;
	for(char i=0; i!=10; i++)
	{
	rc5_send_cmd(5);
	_delay_ms(114);
	}
}
//_delay_ms(3);

//echo_map();

if(effect > 9)
{
if(effect >9 && effect <15)echo_msg(txt1,txt_color1,7,txt2,txt_color2,19);
else if(effect > 14)echo_map(effect-15);
}

init_int0();
}




void set_line(char stat,char color)
{
for(char i=0; i!= 36; i++)
{
led[i][color] = stat;
}

}

void eep_load()
{
	if(eeprom_read_byte ((uint8_t*)0)==128)
	{

		for(char i = 10; i!= 30; i++)
		{
		effect_pause[i-9] = eeprom_read_byte ((uint8_t*)i);
		}

		effect = eeprom_read_byte ((uint8_t*)2);
	}

}



#include "timer.c"


   int main()
   {
   eep_load();
    init_led_array();
   	init_hall();
	ir_led_init();
	uart_init();
	logic_init();
	init_timer();
	adc_init();
	init_int0();
	sei();





//while(1);

	while(m_stat)
{
rc5_send_cmd(15);
_delay_ms(114);
}


while(1)
{
 
if(effect ==1)
{

	for(char i=0; i!=37; i++)
	{
	if(i!=0)led[i-1][RED] = 0;
	led[i][RED] = 1;
	set_red_green_led();
	my_delay(effect_pause[effect]);
	}

	for(char i=0; i!=37; i++)
	{
	if(i!=0)led[i-1][GREEN] = 0;
	led[i][GREEN] = 1;
	set_red_green_led();
	my_delay(effect_pause[effect]);
	}


	for(char i=0; i!=37; i++)
	{
	if(i!=0)led[i-1][BLUE] = 0;
	led[i][BLUE] = 1;
	set_blue_led();
	my_delay(effect_pause[effect]);
	}
}


else if(effect == 2)
{


echo_map(1);



}

else if(effect == 3)
{
	for(char i=0; i!=37; i++)
	{
		set_line(0,RED);
	set_line(0,GREEN);
	set_line(0,BLUE);
	set_red_green_led();
	set_blue_led();

	led[i][RED] = 1;
	set_red_green_led();
	my_delay(effect_pause[effect]);
		led[i][GREEN] = 1;
	set_red_green_led();
	my_delay(effect_pause[effect]);
			led[i][BLUE] = 1;
	set_blue_led();
	my_delay(effect_pause[effect]);
	}

}


else if( effect == 4)
{
	for(char i=0; i!=37; i++)
	{
	set_line(0,BLUE);
	set_blue_led();

	led[i][BLUE] = 1;
	set_blue_led();
	my_delay(effect_pause[effect]);
	}
}


else if(effect == 5)
{
if(read_adc(ILLUM) > 900)set_line(1,BLUE);
else set_line(0,BLUE);
set_blue_led();
}


}


}





