void uart_init(void)
{
UBRRH=0x00;
UBRRL=UART_CALC_BAUDRATE(BAUDRATE);//51
UCSRA = 0x00;
UCSRB = (1<<RXEN)|(1<<TXEN); 
UCSRB |= (1<<RXCIE);
UCSRC = (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0);	
}

void uart_transmit(unsigned char data)
	{
	while ( !( UCSRA & (1<<UDRE)) ); 
	UDR = data;
	}
 
	void uart_transmit_message(char* msg)
		{ 
		unsigned char i;
		i=0; 
	 	while ((i!=255)&(msg[i]!=0x00) ) 
		   {
		   uart_transmit(msg[i]);
		   i++; 
		   }
	}


void eep_save_text()
{
unsigned char st_adr = 0;
unsigned char fin;

if(effect == 10)st_adr = 30;
else if(effect == 11) st_adr = 70;
else if(effect == 12) st_adr = 110;
else return;
fin = st_adr+13;
eeprom_write_byte((uint8_t*)st_adr+19, txt_color1);

for(char i = 0;st_adr!=fin;st_adr++)
{
	eeprom_write_byte((uint8_t*)st_adr, txt1[i]);
	i++;
}


if(effect == 10)st_adr = 30;
else if(effect == 11) st_adr = 70;
else if(effect == 12) st_adr = 110;

st_adr = st_adr + 20;
fin = st_adr+13;


eeprom_write_byte((uint8_t*)st_adr+19, txt_color2);


for(char i = 0;st_adr!=fin;st_adr++)
{

eeprom_write_byte((uint8_t*)st_adr, txt2[i]);

i++;
}

}

void eep_load_text()
{
unsigned char st_adr =0;
unsigned char  fin;
if(effect == 10)st_adr = 30;
else if(effect == 11) st_adr = 70;
else if(effect == 12) st_adr = 110;
else return;

fin = st_adr+13;


txt_color1 = eeprom_read_byte(st_adr+19);

for(char i = 0;st_adr!=fin;st_adr++)
{


txt1[i] = eeprom_read_byte(st_adr);

i++;
}


if(effect == 10)st_adr = 30;
else if(effect == 11) st_adr = 70;
else if(effect == 12) st_adr = 110;

st_adr = st_adr + 20;
fin = st_adr+13;


txt_color2 = eeprom_read_byte(st_adr+19);


for(char i = 0;st_adr!=fin;st_adr++)
{

txt2[i] = eeprom_read_byte(st_adr);

i++;
}



}

void set_effect()
{
if(effect > 9 && effect < 13)eep_load_text();
}

//char speed = 1;
char RX = 0;
unsigned char u_mode = 0;
ISR(USART_RXC_vect)
{
disable_int0();
RX = UDR;
if(u_mode == 0)
{

	if(RX == 'S')
	{
	eeprom_write_byte((uint8_t*)1, 128);
	wdt_enable(0);
	_delay_ms(1000);
	}
	else if(RX == 'm')
	{
	u_mode = 'm';
	uart_transmit_message("MS:");	
	}
		else if(RX == 'M')
	{
	uart_transmit_message("MS:");
	uart_transmit(ms);
	uart_transmit('|');	
	}
	else if(RX == 'e')
	{
	u_mode = 'e';
	uart_transmit_message("Ef:");	
	}
		else if(RX == 'E')
	{
	uart_transmit_message("Ef:");
	uart_transmit(effect);	
	uart_transmit('|');		
	}

	else if(RX == 'p')
	{
	u_mode = 'p';
	uart_transmit_message("EP:");	
	}
		else if(RX == 'P')
	{
	uart_transmit_message("EP:");	
	uart_transmit(effect_pause[effect]);	
	uart_transmit('|');	
	}

	else if(RX == 'l')
	{
	UDR = read_adc(ILLUM)/4;
	}
	else if(RX == 'w')
	{
	eeprom_write_byte((uint8_t*)0, 128);
	uart_transmit_message("EEPEB:");
	eeprom_write_byte((uint8_t*)2, effect);	

	uart_transmit(effect);	
	uart_transmit('|');	
	}
		else if(RX == 'q')
	{
	eeprom_write_byte((uint8_t*)0, 128);
	uart_transmit_message("EEPEP:");
	eeprom_write_byte((uint8_t*)effect+9, effect_pause[effect]);
	uart_transmit(effect_pause[effect]);
	uart_transmit('|');	
	}
			else if(RX == 'a')
	{
	uart_transmit_message("RGBSp");
	uart_transmit(10);	
	uart_transmit(10);	
	uart_transmit('|');	
	}

		
	
	
		else if(RX == 'c')
	{
	uart_transmit_message("TC1:");
	u_mode = 'c';
	}
			else if(RX == 'd')
	{
	uart_transmit_message("TC2:");
	u_mode = 'd';
	}


			else if(RX == 't')
	{
	uart_transmit_message("T1:");
	u_mode = 't';
	txt_counter = 0;
	}

				else if(RX == 'g')
	{
	uart_transmit_message("T2:");
	u_mode = 'g';
	txt_counter = 0;
	}

				else if(RX == 'z')
	{
	uart_transmit_message("ST|");
	eep_save_text();
 	eep_load_text();
	}
	else if(RX == 'F')
	{
	uart_transmit_message("ED:e|");
	ed = 1;
	}
	else if(RX == 'f')
	{
	uart_transmit_message("ED:d|");
	ed = 0;
	}

		else if(RX == 'v')
	{
	uart_transmit_message("SS:");
	uart_transmit(speed_sensor);
	uart_transmit('|');
	}



}

else
{
	if(txt_counter > 11 )//&&(u_mode == 't'||u_mode=='g'
	{
		if(u_mode == 'm')
		{
		ms = RX;
	
		UDR = RX;
		uart_transmit('|');
		u_mode = 0;
		for(char i=0; i!=10; i++){rc5_send_cmd(ms);_delay_ms(114);}
	
		}
		else if(u_mode == 'e')
		{
		effect = RX;
		UDR = RX;
		uart_transmit('|');
		set_effect();		
		u_mode = 0;
		}
		else if(u_mode == 'p')
		{
		effect_pause[effect] = RX;
		UDR = RX;
		uart_transmit('|');
		u_mode = 0;
		}

			else if(u_mode == 'c')
		{
		txt_color2 = RX;
		UDR = txt_color2;
		uart_transmit('|');
		u_mode = 0;
		}
			else if(u_mode == 'd')
		{
		txt_color1 = RX;
		UDR = txt_color1;
		uart_transmit('|');
		u_mode = 0;
		}



	}
	else 
	{
		if(u_mode == 't')
		{
		UDR=RX;
		txt1[txt_counter] = RX;
		txt_counter++;
		}
		else if(u_mode == 'g')
		{
		UDR=RX;
		txt2[txt_counter] = RX;
		txt_counter++;
		}
		if(txt_counter>11)
		{
			uart_transmit('|');
			u_mode = 0;

		}
	}





}

init_int0();
}
