#define led_red_set() PORTC|= (1<<PC3);
#define led_red_rst() PORTC &= ~(1<<PC3);
#define led_red_change() PORTC ^= (1<<PC3);

//char led_line_r, led_line_f;

void uart_init(void)
{
UBRRH=0x00;
//UBRRL=8;//8mGz 57600
UBRRL=25;//4mGz 9600
UCSRA = 0x00;
//UCSRB = (1<<RXEN); 
UCSRB = (1<<RXEN)|(1<<TXEN);
UCSRB |= (1<<RXCIE);
UCSRC = (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0);
}


void led_line_f_set()
{
PORTD |=(1<<PD0);
PORTD &= ~(1<<PD1);
}

void led_line_r_set()
{
PORTD |=(1<<PD1);
PORTD &= ~(1<<PD0);
}

void led_line_rst()
{
PORTD &= ~(1<<PD1);
PORTD &= ~(1<<PD0);
}




	void delay(int ms)
	 {
int c1, c2;
for (c1=0; c1<ms; c1++)
for (c2=0; c2<970; c2++) asm("nop"); 
	}

void motor_r_idle()
{
PORTD |= (1<<PD6);
PORTD &= ~(1<<PD7);
PORTB |= (1<<PB1);
PORTB &= ~(1<<PB0);
}


void init_motor1()
{
motor_r_idle();

DDRD |= (1<<PD6);
DDRD |= (1<<PD7);
DDRB |= (1<<PB0);
DDRB |= (1<<PB1);
}

void motor_r_stop()
{
motor_r_idle();
_delay_ms(1);
PORTB |= (1<<PB0);
PORTD |= (1<<PD7);

}
void motor_l_idle()
{
PORTD |= (1<<PD4);
PORTD &= ~(1<<PD5);
PORTC |= (1<<PC5);
PORTB &= ~(1<<PB6);
}

void init_motor2()
{
motor_l_idle();

DDRD |= (1<<PD4);
DDRD |= (1<<PD5);
DDRC |= (1<<PC5);
DDRB |= (1<<PB6);

}

void init_led()
{
DDRC |= (1<<PC3);
DDRC |= (1<<PC4);

DDRD |= (1<<PD0);
DDRD |= (1<<PD1);



}

void motor_l_stop()
{
motor_l_idle();
_delay_ms(1);
PORTD |= (1<<PD5);
PORTB |= (1<<PB6);
}

void motor_l_run_f()
{
led_line_f_set();
if((PIND & 0b00100000) != 0)
{
PORTD &= ~(1<<PD5);
_delay_ms(1);
}
if((PINC & 0b00100000) == 0)
{
PORTC |= (1<<PC5);
_delay_ms(1);
}
PORTD &= ~(1<<PD4);
PORTB |= (1<<PB6);
}

void motor_l_run_r()
{
led_line_r_set();
if((PIND & 0b00010000) == 0)
{
PORTD |= (1<<PD4);
_delay_ms(1);
}
if((PINB & 0b01000000) != 0)
{
PORTB &= ~(1<<PB6);
_delay_ms(1);
}

PORTD |= (1<<PD5);
PORTC &= ~(1<<PC5);
}

void motor_r_run_f()
{
led_line_f_set();

if((PINB & 0b00000001) != 0)
{
PORTB &= ~(1<<PB0);
_delay_ms(1);
}

if((PINB & 0b00000010) == 0)
{
PORTB |= (1<<PB1);
_delay_ms(1);
}


PORTD &= ~(1<<PD6);
PORTD |= (1<<PD7);
}

void motor_r_run_r()
{
led_line_r_set();
if((PIND & 0b01000000) == 0)
{
PORTD |= (1<<PD6);
_delay_ms(1);
}
if((PIND & 0b10000000) != 0)
{
PORTD &= ~(1<<PD7);
_delay_ms(1);
}

PORTB |= (1<<PB0);
PORTB &= ~(1<<PB1);
}








unsigned char counter = 1;

unsigned char m_r = 16;
unsigned char m_l = 16;
unsigned int wait_data = 0;
unsigned char beep = 0;

ISR(TIMER2_COMP_vect)
{
if((PIND & 0b00001000) == 0)
{

wait_data ++;
}else wait_data =0;

if(wait_data == 2000)
{
m_r=16;
m_l=16;
}

if(beep !=0)
{
PORTC ^= (1<<PC2);
beep --;
}
else  PORTC &= ~(1<<PC2);



if((m_r ==15 || m_r ==16 || m_r == 17)&& ( (PINB & 0b00000001) == 0 || (PIND & 0b10000000) == 0))
{
motor_r_stop();

}

if(m_r > 17)
{
 if(m_r - 17>0 && counter ==1)
  {
  motor_r_run_f();
  }

if(m_r - 17 < counter)
{
motor_r_idle();
}

}

if(m_r < 15)
{


 if(15 - m_r>0 && counter ==1)
  {
  motor_r_run_r();
  }

if(15 - m_r < counter)
{
motor_r_idle();
}

}

if((m_l ==15 || m_l == 16 || m_l == 17) && ((PIND & 0b00100000) == 0 || (PINB & 0b01000000) == 0))
{
motor_l_stop();

}

if(m_l > 17)
{
 if(m_l - 17>0 && counter ==1)
  {
  motor_l_run_f();
  }

if(m_l - 17 < counter)
{
motor_l_idle();
}

}

if(m_l < 15)
{


 if(15 - m_l>0 && counter ==1)
  {
  motor_l_run_r();
  }

if(15 - m_l < counter)
{
motor_l_idle();
}

}



counter++;

if(counter == 16)counter =1;

}





void init_timer()
{
  TCCR2 = (1<<WGM21)|(1<<CS22)| (1<<CS21) |(0<<CS20)  ;
  OCR2 = 4;

  TIMSK |=   (1<<OCIE2);
  
}


void uart_transmit(unsigned char data)
{
while ( !( UCSRA & (1<<UDRE)) ); 
UDR = data;
}

void uart_transmit_message(char* msg)
{ unsigned char i;
i=0; 
while ((i!=255)&(msg[i]!=0x00) ) 
   {
   uart_transmit(msg[i]);
   i++;
   }
}

//char uart_working = 0;
unsigned char u_mode = 0;

ISR(USART_RXC_vect)
{
unsigned char U_D_R = UDR;
uart_transmit_message("RX:");
uart_transmit(U_D_R);
uart_transmit_message("/r/n");

/*
if(u_mode == 0)
{
 u_mode = U_D_R;
UDR = u_mode;
}
else 
{
UDR = 'q';
//beep = 255;
	if(u_mode == 'l') m_l = 5;//U_D_R;
	if(u_mode == 'r') m_r = 5;
	if(u_mode == 'q') {beep = 255; }
	u_mode = 0;
}
*/
}

int main()
{
 OSCCAL = 64;
_delay_ms(50);

TR24Init();

_delay_ms(50);


//init_led();
DDRC |= 0b00000100;//beep
init_motor1();
init_motor2();


init_timer();

uart_init();

beep = 255;
sei();


while(1)
{

//uart_transmit('t');
//delay(500);
}
/*

while(1)
{

	SS_ON;
				_delay_ms(1);
				SS_OFF;

				tr24Mode = TR24_MODE_IDLE;
				TR24SetMode(TR24_MODE_RX);



led_red_change();

			while((PIND & 0b00001000) == 0)
			{
				
			}




TR24ReadBuf(7);

m_l = my_buf[1];
m_r = my_buf[2];

beep = my_buf[3];

}
*/


}
