#include <avr/io.h>
#include "spi.h"

void SPIInit()
{
	SPI_DD  |= (1<<PIN_SSEL)|(1<<PIN_SCK)|(1<<PIN_MOSI);
	SPI_PORT |= (1<<PIN_SSEL);
	SPI_PORT &= ~((1<<PIN_SCK)|(1<<PIN_MOSI));
	SPCR = (1<<SPE) | (1<<MSTR) | (1<<CPHA);
}

unsigned char SPISend(unsigned char db)
{
	SPDR = db;
	while(!(SPSR & (1<<SPIF)));
	return SPDR;
}
