#include "config.h"

#include "tr24a.h"
#include "spi.h"

#include <avr/io.h>
#include <stdlib.h>
#include <stdio.h>
#include <util/delay.h>
#include <avr/pgmspace.h>



volatile unsigned char pktAck = 0;
volatile unsigned char tr24Mode = 0;
unsigned char pktLen=31;
unsigned int buf;

unsigned char channel;





// Framer configuration regs															   
const unsigned char regsFramer[] ={
		0x38,0x90,  
		0xFF,0x8F,  
		0x80,0x28,  
		0x80,0x06,  
		0x4E,0xF6,  
		0xF6,0xF5,  
		0x18,0x5C,  
		0xD6,0x51,  
		0x44,0x44,  
		0xE0,0x00}; 

// RF part configuration regs
const unsigned char regsRF[]={
	   0x09,0x30,0x03,  
	   0x00,0x35,0x4D,  
	   0x02,0x1F,0x01,  
	   0x04,0xBC,0xF0,  
	   0x05,0x00,0xA1,  
	   0x07,0x12,0x09,  
	   0x08,0x80,0x00,  
	   0x0C,0x80,0x00,  
	   0x0E,0x16,0x9B,  
	   0x0F,0x90,0xAD,  
	   0x10,0xB0,0x00,  
	   0x13,0xA1,0x14,  
	   0x14,0x81,0x91,  
	   0x16,0x00,0x02,  
	   0x18,0xB1,0x40,  
	   0x19,0xA8,0x0F,  
	   0x1A,0x3F,0x04,  
	   0x1C,0x58,0x00}; 



//***********************************************************************************

void TR24Reset()
{

    PORT_RESET&= ~(1<<PIN_RESET);
    _delay_ms(2);
    PORT_RESET|= (1<<PIN_RESET);
    _delay_ms(5); // T1 1-5ms
	tr24Mode = TR24_MODE_IDLE;


}

//***********************************************************************************
//TR24 initialization
unsigned char TR24Init()
{

	unsigned int regData;


	DDR_PKT&=~(1<<PIN_PKT);
    PORT_RESET|= (1<<PIN_RESET);
    DDR_RESET|=(1<<PIN_RESET);
//	DDRD |= 0x04; power

	SPIInit();
	
	channel=50;//85;   


	TR24Reset();
	
	//framer init
	SS_ON;
	SPISend(0x30);//first framer reg
	
	unsigned char i;
	for(i=0;i<sizeof(regsFramer);i+=2)
	{
		SPISend(regsFramer[i]);  
		SPISend(regsFramer[i+1]);

	}
	SS_OFF;
	_delay_ms(2);  //T2 2ms 
	//RF init
	for(i=0;i<sizeof(regsRF);i=i+3)		      
	{
		regData = (regsRF[i+1]<<8) + regsRF[i+2];
		TR24WriteReg(regsRF[i],regData);
	}



	return 0;
}


//***********************************************************************************
// immediately send packet. maximal packet size 63 bytes

void TR24SendBuf(unsigned char packetLen)
{




	if (tr24Mode!=TR24_MODE_IDLE)
		TR24SetMode(TR24_MODE_IDLE);

	TR24WriteReg(0x52,0x8000); 
	TR24SetMode(TR24_MODE_TX);
	pktAck=0;

	SS_ON;
	_delay_us(1);
    SPISend(0x50);   //reg80
    SPISend(packetLen);    // 
	int counter = 0;
	while (packetLen--)
    {
    //	SPISend(*buf++);
SPISend(sendd[counter]);
counter ++;
    }
	
    SS_OFF;
}


//***********************************************************************************
// read from TR24 FIFO after packet received
unsigned char TR24ReadBuf(unsigned char packetLenReq)
{
//	unsigned char i;
	unsigned char packetLen; 

	SS_ON;
	_delay_us(1);
	SPISend(0x50|(1<<7));  
	packetLen=SPISend(0xFF);	

	if (packetLenReq && (packetLen!=packetLenReq))
	{
		return 0; // packet length differs than the requested
	}
	if (packetLen >63) //packet size overflow
	{
		return 0; 
	}
int counter = 0;
	while (packetLen--)
    {
my_buf[counter] = SPISend(0xFF);
counter ++;
    }

	SS_OFF;

	return packetLenReq;
}



//***********************************************************************************
unsigned char TR24GetMode()
{
//	unsigned int buf;
	buf= TR24ReadReg(0x40); 
	buf = buf>>12;
	return (unsigned char)buf;
}




//***********************************************************************************
void TR24SetMode (unsigned char mode)
{
	unsigned int regData;
	switch (mode)
	{
		case TR24_MODE_SLEEP:

			regData=TR24ReadReg(48);
			regData|=1<<2;
			TR24WriteReg(48,regData);
		break;
		case TR24_MODE_IDLE:
			regData=TR24ReadReg(0x07);
			regData&=~((1<<7) | (1<<8));
			TR24WriteReg(0x07,regData);  
		break;
		case TR24_MODE_TX:
			TR24WriteReg(0x07,(0x09<<9)+channel+(1<<8));  
		break;
		case TR24_MODE_RX:
			if ((tr24Mode!=TR24_MODE_IDLE) && (tr24Mode!=TR24_MODE_RX))
			{
				regData=TR24ReadReg(0x07);
				regData&=~((1<<7) | (1<<8));
				TR24WriteReg(0x07,regData);  
			}
			TR24WriteReg(0x07,(0x09<<9)+channel+(1<<7));  
		break;


	}
	tr24Mode = mode;

}

 
//***********************************************************************************
char TR24CheckCRC()
{
	unsigned int buf;
	buf = TR24ReadReg(0x40);  
	if (buf & (1<<11))
		return -1;
	else
		return 0;
}





//***********************************************************************************
void TR24WriteReg(unsigned char regNum,unsigned int regData)
{
	
	SS_ON;
	SPISend(regNum);   
	SPISend(regData>>8);   
	SPISend(regData&0xFF);   
	SS_OFF;
}

//***********************************************************************************
unsigned int TR24ReadReg(unsigned char regNum)
{

	unsigned int result;
	SS_ON;
	SPISend(regNum | 0x80);   
	result=SPISend(0x0FF)<<8;
	result|=SPISend(0x0FF);
	SS_OFF;
	return result;

}

unsigned char TR24GetTemp()
{

return TR24ReadReg(0x03)*4;

}

