#ifndef _TR24A_H_
#define _TR24A_H_



#include <avr/io.h>
#include <stdlib.h>
#include <stdio.h>
#include <avr/pgmspace.h>


//#define CAR 1
//#define REMOTE 1

#define CDROBOT_2_1 1



#if CDROBOT_2_1

//#define PIN_FIFO  PB1  //in
#define PIN_PKT   PD3  //in
#define PORT_PKT  PIND  //in
#define DDR_PKT   DDRD  //in

#define PIN_RESET  PB7  //out
#define PORT_RESET PORTB  //out
#define DDR_RESET  DDRB  //out 

#endif



#if CAR

//#define PIN_FIFO  PB1  //in
#define PIN_PKT   PD6  //in
#define PORT_PKT  PIND  //in
#define DDR_PKT   DDRD  //in

#define PIN_RESET  PB0  //out
#define PORT_RESET PORTB  //out
#define DDR_RESET  DDRB  //out 

#endif




#if REMOTE

//#define PIN_FIFO  PB1  //in

#define PIN_PKT   PB0  //in
#define PORT_PKT  PINB  //in
#define DDR_PKT   DDRB  //in

#define PIN_RESET  PD5  //out
#define PORT_RESET PORTD  //out
#define DDR_RESET  DDRD  //out 

#endif


 
#define TR24_MODE_IDLE 0b1100
#define TR24_MODE_TX 0b1110
#define TR24_MODE_RX 0b1101
#define TR24_MODE_SLEEP 0b1000
#define TR24_MODE_POWERDOWN 0x0
//#define TR24_MODE_TX_START 1+16


extern unsigned char packetBuf[64];
extern volatile unsigned char tr24Mode;
extern const unsigned char regsFramer[];
extern const unsigned char regsRF[];
extern unsigned char pktState;
extern volatile unsigned char pktAck;
extern unsigned int pktCounterRX;
extern unsigned int pktCounterTX;
extern unsigned int byteCounterRX;
extern unsigned int byteCounterTX;
extern unsigned char pktLen;
extern unsigned int errCounter;
extern unsigned int myErrCounter;
extern volatile unsigned char statTimer;
extern unsigned char verbose;
extern unsigned char loop;
//extern unsigned char ping;
extern unsigned char mcusr;
extern unsigned char channel;
extern unsigned char nextChannel;
extern unsigned int timer1;

unsigned char my_buf[64];


char sendd[64];


 

void TR24Reset();
//TR24 initialization
unsigned char TR24Init();
// immediately send packet. maximal packet size 63 bytes
void TR24SendBuf(unsigned char packetLen);
// read from TR24 FIFO after packet received
unsigned char TR24ReadBuf(unsigned char packetLenReq);
unsigned char TR24GetMode();
void TR24SetMode (unsigned char mode);
char TR24CheckCRC();
void TR24WriteReg(unsigned char regNum,unsigned int regData);
unsigned int TR24ReadReg(unsigned char regNum);

unsigned char TR24GetTemp();


#endif // _TR24A_H_
