#include <avr/io.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <avr/sleep.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h> 
#include <avr/pgmspace.h>


#define AUDIO_IN 7
#define SCL PC5
#define SDA PC4
#define UP_BTN PC3
#define DOWN_BTN PD3
#define MUTE PB0

#define set_r() PORTC |= (1<<PC0)
#define set_g() PORTC |= (1<<PC1)
#define set_b() PORTC |= (1<<PC2)

#define rst_r() PORTC &= ~(1<<PC0)
#define rst_g() PORTC &= ~(1<<PC1)
#define rst_b() PORTC &= ~(1<<PC2)

#define set_mute() PORTB|= (1<<MUTE)
#define rst_mute() PORTB &= ~(1<<MUTE)





char btn_up_is_en()
{
if((PINC&(1<<UP_BTN) ) ==0) return 1;
return 0;
}

char btn_down_is_en()
{
if((PIND&(1<<DOWN_BTN) ) ==0) return 1;
return 0;
}


#define TWI_START       0
#define TWI_RESTART         1
#define TWI_STOP            2
#define TWI_TRANSMIT        3
#define TWI_RECEIVE_ACK     4
#define TWI_RECEIVE_NACK    5
 
uint8_t twi(uint8_t action){
    switch(action){
        case TWI_START:
        case TWI_RESTART:
            TWCR = _BV(TWSTA) | _BV(TWEN) | _BV(TWINT) ;//| _BV(TWIE);
            break;
        case TWI_STOP: 
            TWCR = _BV(TWSTO) | _BV(TWEN) | _BV(TWINT);// | _BV(TWIE);
            break;
        case TWI_TRANSMIT: 
            TWCR = _BV(TWEN) | _BV(TWINT);// | _BV(TWIE);
            break;
        case TWI_RECEIVE_ACK:
            TWCR = _BV(TWEN)  | _BV(TWEA)| _BV(TWINT);//| _BV(TWIE);
            break;
        case TWI_RECEIVE_NACK:
            TWCR = _BV(TWEN) | _BV(TWINT);// | _BV(TWIE);
            break;
        }
    if(action != TWI_STOP)while (!(TWCR & _BV(TWINT)));   
    return (TWSR & 0xF8);
}


#define SELECTOR_ADR 0b10010100
#define POCESSOR_ADR 0b10001000

uint8_t twi_res()
{
return (TWSR & 0b11111000);
}

char send_adr(char adr)
{
twi(TWI_START);
TWDR=adr;
if(twi(TWI_TRANSMIT) == 0x18 ) return 1;
set_r();
return 0;
}


char send_data(char data)
{
TWDR=data;
if(twi(TWI_TRANSMIT) == 0x28 ) return 1;
return 0;
}

void init_twi()
{

PORTC |= (1<<SCL)|(1<<SDA);
DDRC &=~(1<<SCL);
DDRC &=~(1<<SDA);


TWSR &= ~(_BV(TWPS0)|_BV(TWPS1)); //  
//TWSR |= (1<<TWPS0)|(1<<TWPS1);
TWBR=60;//171;//114;                         //   
                                  //( 8MHz F_CPU  8000000/(2*(16+114)) = 32kHz)
}

char set_ch(char ch)
{
if(send_adr(SELECTOR_ADR) == 0)return 0;

char ch_arr[] = {0b11001011, 0b11001010, 0b11001001, 0b11001000};
/*
0b11001011;//in 1 
0b11001010;//in 2
0b11001001;//in 3
0b11001000;//in 4
*/

if(send_data(ch_arr[ch-1]) == 0) return 0;//in 2

//if(send_data(0b11010001) == 0) break;//Enhanced Surround Function Disabled 

if(send_data(0b11110110) == 0) return 0;// SUB Mute off

//if(send_data(0b11110000) == 0) break;// FL Mute 

//if(send_data(0b11110010) == 0) break;// FR Mute 

//if(send_data(0b11010000) == 0) break;//Enhanced Surround Function en

//if(send_data(0b10010001) == 0) break;//Mixed Channel (+6dB) Setup 


twi(TWI_STOP);
return 1;
}

char init_audio_cpu()
{

if(send_adr(POCESSOR_ADR) == 0)return 0;

if(send_data(0b11111111) == 0) return 0;//clear reg

twi(TWI_STOP);
_delay_ms(100);



if(send_adr(POCESSOR_ADR) == 0)return 0;

if(send_data(0b11000111) == 0) return 0;//on 7ch

twi(TWI_STOP);
_delay_ms(100);



if(send_adr(POCESSOR_ADR) == 0)return 0;

if(send_data(0b01110111) == 0) return 0;//mute off and other

/*
if(send_data(0b00010000) == 0) return 0;//fr left 0db

if(send_data(0b00100000) == 0) return 0;//fr right 0db

if(send_data(0b01100000) == 0) return 0;//Subwoofer volume TRIM control 
*/
/*
if(send_data(0b11100100) == 0) return 0;//master -40db set
if(send_data(0b11010000) == 0) return 0;//master 0db set
*/
twi(TWI_STOP);

return 1;
}



char usb_is_connected()
{
if((PIND&(1<<PD4)) != 0)return 1;
return 0;
}



volatile unsigned char r,g,b,c, usb_been_conn_before = 0;

volatile unsigned int start_timer =0;


#define MAX_COL 18
ISR(TIMER2_COMP_vect)
{

if(start_timer < 1000)
{
	start_timer++;
	if(usb_is_connected())usb_been_conn_before = 1;
}

if(usb_is_connected() == 0)usb_been_conn_before = 0;

if(usb_is_connected() && usb_been_conn_before == 0) {wdt_enable(0);_delay_ms(2000);}


	if(r > 0)set_r();
	if(g > 0)set_g();
	if(b > 0)set_b();

	if(c > r)rst_r();
	if(c > g)rst_g();
	if(c > b)rst_b();


	if(c == MAX_COL) c = 0;//31
	else c++;

}


void set_col(unsigned char vol)
{
vol = vol - 20;
if(vol > 200) vol = 0;
if(vol > 72) vol = 72;
	if(vol >= 54)
	{
	r = 0;
	b = MAX_COL;
	g = 18-(vol-54);

	}

	else if(vol >= 36)
	{
	g = MAX_COL;
	r=0;
	b = vol-36;
	}

	else if(vol >= 18)
	{
	g = MAX_COL;
	b=0;
	r = 18-(vol-18);

	}

		else if(vol >= 0)
	{
	b = 0;
	r =MAX_COL;
	g = vol;

	}
}







char set_volume(unsigned char vol)
{
	if(send_adr(POCESSOR_ADR) == 0)return 0;
	send_data(0b11100000| ( (vol/10)%10 )  );
	send_data(0b11010000|(vol%10));
	twi(TWI_STOP);
	set_col(vol);
	return 1;
}

void init_timer()
{
  TCCR2 = (1<<WGM21)|(1<<CS22)| (1<<CS21) |(1<<CS20)  ;
  OCR2 = 5;

  TIMSK |=   (1<<OCIE2);
  sei();
}


















/*
void wait_adc_conv()
{
while ((ADCSRA & 0x10)==0);
}

void run_adc()
{
	unsigned char ch = 7;
	ch |= (1<<REFS0);
	ADMUX = ch;
	ADCSRA |= (1<<ADEN)|(1<<ADSC)|(1<<ADFR)|(1<<ADPS1)|(1<<ADPS0);
	wait_adc_conv();
}


unsigned int read_adc() 
{
	unsigned int adcw; //  
	char a;
	char b;
	a=ADCL; //   -  ,
	b=ADCH; //   
	b&=0x03;
	adcw=b; 
	adcw=adcw<<8;
	adcw=adcw+a;
	return adcw;
}*/









void adc_init(void)
{
	 ACSR  = 0x80;
	 ADCSRA = 0xC6;
}

unsigned int read_adc(char adc_input) 
{
	unsigned int adcw; //  
	char a;
	char b;
	adc_input |= (1<<REFS0);
	ADMUX=adc_input; //   
	ADCSRA|=0x40; //  - 
	while ((ADCSRA & 0x10)==0); //   
	a=ADCL; //   -  ,
	b=ADCH; //   
	b&=0x03;
	adcw=b; 
	adcw=adcw<<8;
	adcw=adcw+a;
	return adcw;
}










/*
ISR(INT0_vect)
{
g =1;

}*/

void init_ext_int()
{
MCUCR |= (1<<ISC00);
GICR |= (1<INT0);
}

int main()
{
adc_init();
DDRC |= (1<<PC0)|(1<<PC1)|(1<<PC2);
DDRB |= (1<<MUTE);
PORTC |= (1<<UP_BTN);
PORTD |= (1<<DOWN_BTN);

DDRD &= ~(1<<PD4);
PORTD &= ~(1<<PD4);

init_timer();


r =1;
g =1;
b =1;



_delay_ms(1000);

read_adc(7);




/*
b = MAX_COL;

for(g=0; g!=MAX_COL; g++) {while(c != 0);_delay_ms(50);}


for(b=MAX_COL; b!=0; b--) {while(c != 0); _delay_ms(50);}


for(r=0; r!=MAX_COL; r++) {while(c != 0); _delay_ms(50);}


for(g=MAX_COL; g!=0; g--) {while(c != 0); _delay_ms(50);}

*/

//r = 255;




init_twi();
_delay_ms(100);

char error =0;
unsigned char volume = 0;
while(1)
{
	error =1;
	if(set_ch(2) == 0)break;
	_delay_ms(100);

	if(init_audio_cpu() == 0) break; 
	_delay_ms(100);

//	set_g();
	error = 0;
	break;
}

_delay_ms(100);

volume = 50;
set_volume(volume);

unsigned int last_adc_val = read_adc(7);
unsigned int mute_timer =0;
unsigned char button_timer = 0;

char mute_en = 0;


while(error == 0)
{

if(mute_timer < 6000)//10 min
{
	if(btn_down_is_en())
	{
	button_timer = 0;
	set_volume(volume);
	if(volume < 70) volume = volume +1;
	
	}

	if(btn_up_is_en())
	{
	button_timer = 0;
	set_volume(volume);
	if(volume > 0) volume = volume -1;
	}
	if(volume == 70) set_mute();
	else rst_mute();

	_delay_ms(100);
	if(button_timer <100) button_timer++;
	else {r=0;g=0;b=0;}
}
//else _delay_ms(10);

	unsigned int new_adc_val = read_adc(7);
	

	if( new_adc_val > (last_adc_val + 10) || new_adc_val < (last_adc_val - 10) ) {mute_timer = 0; }
	else if(mute_timer < 65500) {mute_timer ++; }
	if(mute_timer > 6000){set_mute();mute_en =1; r=0;g=0;b=0;}
	else if(mute_en == 1){rst_mute();set_col(volume);button_timer =0;mute_en =0;}


	last_adc_val =read_adc(7);


//g =1;
//r= 0;
//b= 0;
}


while(1);


}
